package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.ReenvioComunicaciones;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * ReenvioComunicacionesDaoImpl NO generated by UDA, 28-ago-2017.
 * 
 * @author NO UDA
 */

@Repository()
@Transactional()
public class ReenvioComunicacionesDaoImpl implements ReenvioComunicacionesDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ReenvioComunicaciones> rwMap = new RowMapper<ReenvioComunicaciones>() {
		public ReenvioComunicaciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new ReenvioComunicaciones(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getLong("NUMOS"),
					resultSet.getDate("FECPRE"), resultSet.getString("NOMEMP"),
					resultSet.getString("NUMDOC"));

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource
	 *            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Finds rows in the Ab04b56s00 or Ab04b60s00 or Ab04b61s00 table joined
	 * with Ab04b77s00.
	 * 
	 *  reenvioComunicaciones
	 *            ReenvioComunicaciones
	 * 
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<ReenvioComunicaciones>
	 *
	 * @param reenvioComunicaciones the reenvio comunicaciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<ReenvioComunicaciones> findReenvioComunicaciones(
			ReenvioComunicaciones reenvioComunicaciones,
			JQGridRequestDto jqGridRequestDto) {

		String mascara = Utilities.getInstance().getDateMask();

		// Pongo uno de los tres, en este caso el de apertura
		String tipoPresentacion = "2";
		String tabla = "56";
		String select = "t1.TERAPE_0" + tabla + " TEROS, t1.ANOAPE_0" + tabla
				+ " ANOOS, t1.NUMAPE_0" + tabla + " NUMOS, t1.FECPRE_0" + tabla
				+ " FECPRE, t1.NOMEMP_0" + tabla + " NOMEMP, t1.NUMDOC_0"
				+ tabla + " NUMDOC";
		String leftjoin = " ON t1.ANOAPE_0" + tabla
				+ " = t2.ANOEXP_077 AND t1.TERAPE_0" + tabla
				+ " = t2.TEREXP_077 AND t1.NUMAPE_0" + tabla
				+ " = t2.NUMEXP_077 and t2.TIPEXP_077 = '" + tipoPresentacion
				+ "' ";
		String where = " AND t1.TERAPE_0" + tabla + " = '"
				+ reenvioComunicaciones.getTerritorioExpediente077() + "'";

		if (Constantes.OS2.equals(reenvioComunicaciones.getTipoPresentacion())) {
			tipoPresentacion = "3";
			tabla = "60";
			select = "t1.TEROS2_0" + tabla + " TEROS, t1.ANOOS2_0" + tabla
					+ " ANOOS, t1.NUMOS2_0" + tabla + " NUMOS, t1.FECPRE_0"
					+ tabla + " FECPRE, t1.NOMEMP_0" + tabla
					+ " NOMEMP, t1.NUMDOC_0" + tabla + " NUMDOC";
			leftjoin = " ON t1.ANOOS2_0" + tabla
					+ " = t2.ANOEXP_077 AND t1.TEROS2_0" + tabla
					+ " = t2.TEREXP_077 AND t1.NUMOS2_0" + tabla
					+ " = t2.NUMEXP_077  and t2.TIPEXP_077 = '"
					+ tipoPresentacion + "' ";
			where = " AND t1.TEROS2_0" + tabla + " = '"
					+ reenvioComunicaciones.getTerritorioExpediente077() + "'";

		} else if (Constantes.OS3.equals(reenvioComunicaciones
				.getTipoPresentacion())) {
			tipoPresentacion = "4";
			tabla = "61";
			select = "t1.TEROS3_0" + tabla + " TEROS, t1.ANOOS3_0" + tabla
					+ " ANOOS, t1.NUMOS3_0" + tabla + " NUMOS, t1.FECPRE_0"
					+ tabla + " FECPRE, t1.NOMEMP_0" + tabla
					+ " NOMEMP, t1.NUMDOC_0" + tabla + " NUMDOC";
			leftjoin = " ON t1.ANOOS3_0" + tabla
					+ " = t2.ANOEXP_077 AND t1.TEROS3_0" + tabla
					+ " = t2.TEREXP_077 AND t1.NUMOS3_0" + tabla
					+ " = t2.NUMEXP_077  and t2.TIPEXP_077 = '"
					+ tipoPresentacion + "' ";
			where = " AND t1.TEROS3_0" + tabla + " = '"
					+ reenvioComunicaciones.getTerritorioExpediente077() + "'";
		}

		StringBuilder query = new StringBuilder("SELECT ");
		query.append(select);

		query.append(" FROM AB04" + tabla + "S00 t1 left join  AB0477S00 t2 ");
		query.append(leftjoin);
		query.append(" WHERE  ");

		query.append(" t1.FECPRE_0" + tabla
				+ " is not null and t2.FOLDERID_077 is null ");

		if (null != reenvioComunicaciones.getTerritorioExpediente077()) {
			query.append(where);
		}

		if (null != reenvioComunicaciones.getFecpreDesdeStr()
				&& !"".equals(reenvioComunicaciones.getFecpreDesdeStr())) {
			query.append(" AND TRUNC(FECPRE_0" + tabla + ") >= trunc(to_date('"
					+ reenvioComunicaciones.getFecpreDesdeStr() + "', '"
					+ mascara + "')) ");
		}

		if (null != reenvioComunicaciones.getFecpreHastaStr()
				&& !"".equals(reenvioComunicaciones.getFecpreHastaStr())) {
			query.append(" AND TRUNC(FECPRE_0" + tabla + ") <= trunc(to_date('"
					+ reenvioComunicaciones.getFecpreHastaStr() + "', '"
					+ mascara + "')) ");
		}

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ReenvioComunicaciones>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap);
	}

	/**
	 * Finds then number of the rows in the ComunicacionApertura or OS2 or OS3
	 * table for Reenvio de Comunicaciones.
	 * 
	 *  reenvioComunicaciones
	 *            ReenvioComunicaciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  Long
	 *
	 * @param reenvioComunicaciones the reenvio comunicaciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	public Long findReenvioComunicacionesCount(
			ReenvioComunicaciones reenvioComunicaciones,
			JQGridRequestDto jqGridRequestDto) {

		String mascara = Utilities.getInstance().getDateMask();

		// Pongo uno de los tres, en este caso el de apertura
		String tipoPresentacion = "2";
		String tabla = "56";
		String select = " COUNT(1) ";
		String leftjoin = " ON t1.ANOAPE_0" + tabla
				+ " = t2.ANOEXP_077 AND t1.TERAPE_0" + tabla
				+ " = t2.TEREXP_077 AND t1.NUMAPE_0" + tabla
				+ " = t2.NUMEXP_077   and t2.TIPEXP_077 = '" + tipoPresentacion
				+ "' ";
		String where = " AND t1.TERAPE_0" + tabla + " = '"
				+ reenvioComunicaciones.getTerritorioExpediente077() + "'";

		if (Constantes.OS2.equals(reenvioComunicaciones.getTipoPresentacion())) {
			tipoPresentacion = "3";
			tabla = "60";
			leftjoin = " ON t1.ANOOS2_0" + tabla
					+ " = t2.ANOEXP_077 AND t1.TEROS2_0" + tabla
					+ " = t2.TEREXP_077 AND t1.NUMOS2_0" + tabla
					+ " = t2.NUMEXP_077 and t2.TIPEXP_077 = '"
					+ tipoPresentacion + "' ";
			where = " AND t1.TEROS2_0" + tabla + " = '"
					+ reenvioComunicaciones.getTerritorioExpediente077() + "'";

		} else if (Constantes.OS3.equals(reenvioComunicaciones
				.getTipoPresentacion())) {
			tipoPresentacion = "4";
			tabla = "61";
			leftjoin = " ON t1.ANOOS3_0" + tabla
					+ " = t2.ANOEXP_077 AND t1.TEROS3_0" + tabla
					+ " = t2.TEREXP_077 AND t1.NUMOS3_0" + tabla
					+ " = t2.NUMEXP_077 and t2.TIPEXP_077 = '"
					+ tipoPresentacion + "' ";
			where = " AND t1.TEROS3_0" + tabla + " = '"
					+ reenvioComunicaciones.getTerritorioExpediente077() + "'";
		}

		StringBuilder query = new StringBuilder("SELECT ");
		query.append(select);

		query.append(" FROM AB04" + tabla + "S00 t1 left join  AB0477S00 t2 ");
		query.append(leftjoin);
		query.append(" WHERE  ");

		query.append(" t1.FECPRE_0" + tabla
				+ " is not null and t2.FOLDERID_077 is null ");

		if (null != reenvioComunicaciones.getTerritorioExpediente077()) {
			query.append(where);
		}

		if (null != reenvioComunicaciones.getFecpreDesdeStr()
				&& !"".equals(reenvioComunicaciones.getFecpreDesdeStr())) {
			query.append(" AND TRUNC(FECPRE_0" + tabla + ") >= trunc(to_date('"
					+ reenvioComunicaciones.getFecpreDesdeStr() + "', '"
					+ mascara + "')) ");
		}

		if (null != reenvioComunicaciones.getFecpreHastaStr()
				&& !"".equals(reenvioComunicaciones.getFecpreHastaStr())) {
			query.append(" AND TRUNC(FECPRE_0" + tabla + ") <= trunc(to_date('"
					+ reenvioComunicaciones.getFecpreHastaStr() + "', '"
					+ mascara + "')) ");
		}

		return this.getJdbcTemplate().queryForLong(query.toString(),
				new Object[] {});
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
